/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////// CCI Cross Arrows TT ///////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////

#property copyright "Copyright  2015, http://forexsystems.ru/"
#property link      "http://forexsystems.ru/"
#property description " CCI -    :))"

#property indicator_chart_window
#property indicator_buffers 8

//#property indicator_color1 Red// Kleurloos
//#property indicator_color2 DodgerBlue//Kleurloos
//#property indicator_color3 Red//DodgerBlue
//#property indicator_color4 Red
//#property indicator_color5 DodgerBlue//Kleurloos
//#property indicator_color6 Red//Kleurloos

//---- input parameters
extern int  FastCCI     = 14;
extern int  levelUp_1 = -100;
extern int  levelDn_1 = 100;
extern int  SlowCCI     = 42;
extern int  levelUp_2 = -100;
extern int  levelDn_2 = 100;
extern int  VerySlowCCI = 210;
extern int  levelUp_3 = -100;
extern int  levelDn_3 = 100;
extern int  TrendCCI = 280;
extern int  levelUp_4 = -100;
extern int  levelDn_4 = 100;

extern string note     = "CCI Arrows Identifier";
extern int arrowsGap_1 = 15;
extern int arrowsGap_2 = 25;
extern int arrowsGap_3 = 35;
extern int arrowsGap_4 = 70;

extern color  arrowsColorUp_1   = White; /// DodgerBlue
extern color  arrowsColorDn_1   = Red; /// OrangeRed;
extern int    arrowsSize_1      = 1;
extern int    arrowsUPcode_1    = 233;
extern int    arrowsDNcode_1    = 234;
extern color  arrowsColorUp_2   = Aqua; /// DodgerBlue
extern color  arrowsColorDn_2   = Orange; /// OrangeRed;
extern int    arrowsSize_2      = 2;
extern int    arrowsUPcode_2    = 241;
extern int    arrowsDNcode_2    = 242;
extern color  arrowsColorUp_3   = DodgerBlue; /// DodgerBlue
extern color  arrowsColorDn_3   = Magenta; /// OrangeRed;
extern int    arrowsSize_3      = 3;
extern int    arrowsUPcode_3    = 217;
extern int    arrowsDNcode_3    = 218;
extern color  arrowsColorUp_4   = LimeGreen; //DodgerBlue; /// DodgerBlue
extern color  arrowsColorDn_4   = Gold; //Magenta; /// OrangeRed;
extern int    arrowsSize_4      = 4;
extern int    arrowsUPcode_4    = 175;
extern int    arrowsDNcode_4    = 175;

extern string note_     = "CCI Arrows Type";
extern string note1    = "233-234, 225-226, 217-218, 236-238, 147";
extern string note2    = "241-242, 221-222, 228-230, 246-248, 108";
extern string note3    = "120, 110, 117, 121, 171, 172, 174, 181, 203";

extern bool AlertsON = true;


//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
double ExtMapBuffer7[];
double ExtMapBuffer8[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW, STYLE_SOLID, arrowsSize_1, arrowsColorUp_1);
   SetIndexStyle(1, DRAW_ARROW, STYLE_SOLID, arrowsSize_1, arrowsColorDn_1);
   SetIndexStyle(2, DRAW_ARROW, STYLE_SOLID, arrowsSize_2, arrowsColorUp_2);
   SetIndexStyle(3, DRAW_ARROW, STYLE_SOLID, arrowsSize_2, arrowsColorDn_2);
   SetIndexStyle(4, DRAW_ARROW, STYLE_SOLID, arrowsSize_3, arrowsColorUp_3);
   SetIndexStyle(5, DRAW_ARROW, STYLE_SOLID, arrowsSize_3, arrowsColorDn_3);
   SetIndexStyle(6, DRAW_ARROW, STYLE_SOLID, arrowsSize_4, arrowsColorUp_4);
   SetIndexStyle(7, DRAW_ARROW, STYLE_SOLID, arrowsSize_4, arrowsColorDn_4);

   SetIndexArrow(0,arrowsUPcode_1);
   SetIndexArrow(1,arrowsDNcode_1);
   SetIndexArrow(2,arrowsUPcode_2);
   SetIndexArrow(3,arrowsDNcode_2);
   SetIndexArrow(4,arrowsUPcode_3);
   SetIndexArrow(5,arrowsDNcode_3);
   SetIndexArrow(6,arrowsUPcode_4);
   SetIndexArrow(7,arrowsDNcode_4);

    
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexBuffer(3,ExtMapBuffer4);
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexBuffer(5,ExtMapBuffer6);
   SetIndexBuffer(6,ExtMapBuffer7);
   SetIndexBuffer(7,ExtMapBuffer8);

   SetIndexEmptyValue(0,0.0);
   SetIndexEmptyValue(1,0.0);
   SetIndexEmptyValue(2,0.0);
   SetIndexEmptyValue(3,0.0);
   SetIndexEmptyValue(4,0.0);
   SetIndexEmptyValue(5,0.0);
   SetIndexEmptyValue(6,0.0);
   SetIndexEmptyValue(7,0.0);

   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int shift;
   for(shift=Bars-1;shift>=0;shift--)
      {	
      ExtMapBuffer1[shift] = 0; ExtMapBuffer2[shift] = 0; ExtMapBuffer3[shift] = 0;
      ExtMapBuffer4[shift] = 0; ExtMapBuffer5[shift] = 0; ExtMapBuffer6[shift] = 0;
      ExtMapBuffer7[shift] = 0; ExtMapBuffer8[shift] = 0;

      double fCCI_0 = iCCI(NULL, 0, FastCCI, PRICE_TYPICAL, shift);
      double fCCI_1 = iCCI(NULL, 0, FastCCI, PRICE_TYPICAL, shift+1);
      double fCCI_2 = iCCI(NULL, 0, FastCCI, PRICE_TYPICAL, shift+2);
      
      if (fCCI_0 > levelUp_1 && fCCI_1 < levelUp_1 && fCCI_2 < levelUp_1)
        ExtMapBuffer1[shift] = Low[shift] - arrowsGap_1 * Point; 
   
      if (fCCI_0 < levelDn_1 && fCCI_1 > levelDn_1 && fCCI_2 > levelDn_1)
        ExtMapBuffer2[shift] = High[shift] + arrowsGap_1 * Point; 

      double sCCI_0 = iCCI(NULL, 0, SlowCCI, PRICE_TYPICAL, shift);
      double sCCI_1 = iCCI(NULL, 0, SlowCCI, PRICE_TYPICAL, shift+1);
      double sCCI_2 = iCCI(NULL, 0, SlowCCI, PRICE_TYPICAL, shift+2);
      
      if (sCCI_0 > levelUp_2 && sCCI_1 < levelUp_2 && sCCI_2 < levelUp_2)
        ExtMapBuffer3[shift] = Low[shift] - arrowsGap_2 * Point; 
   
      if (sCCI_0 < levelDn_2 && sCCI_1 > levelDn_2 && sCCI_2 > levelDn_2)
        ExtMapBuffer4[shift] = High[shift] + arrowsGap_2 * Point; 

      double vsCCI_0 = iCCI(NULL, 0, VerySlowCCI, PRICE_TYPICAL, shift);
      double vsCCI_1 = iCCI(NULL, 0, VerySlowCCI, PRICE_TYPICAL, shift+1);
      double vsCCI_2 = iCCI(NULL, 0, VerySlowCCI, PRICE_TYPICAL, shift+2);
      
      if (vsCCI_0 > levelUp_3 && vsCCI_1 < levelUp_3 && vsCCI_2 < levelUp_3)
        ExtMapBuffer5[shift] = Low[shift] - arrowsGap_3 * Point; 
   
      if (vsCCI_0 < levelDn_3 && vsCCI_1 > levelDn_3 && vsCCI_2 > levelDn_3)
        ExtMapBuffer6[shift] = High[shift] + arrowsGap_3 * Point; 
        
      double tCCI_0 = iCCI(NULL, 0, TrendCCI, PRICE_TYPICAL, shift);
      double tCCI_1 = iCCI(NULL, 0, TrendCCI, PRICE_TYPICAL, shift+1);
      double tCCI_2 = iCCI(NULL, 0, TrendCCI, PRICE_TYPICAL, shift+2);
      
      if (tCCI_0 > levelUp_4 && tCCI_1 < levelUp_4 && tCCI_2 < levelUp_4)
        ExtMapBuffer7[shift] = Low[shift] - arrowsGap_4 * Point; 
   
      if (tCCI_0 < levelDn_4 && tCCI_1 > levelDn_4 && tCCI_2 > levelDn_4)
        ExtMapBuffer8[shift] = High[shift] + arrowsGap_4 * Point;
   }

   string sComment = "";
   if (ExtMapBuffer1[0] != 0)
      sComment = sComment + " 1st UP";
      
   if (ExtMapBuffer2[0] != 0)
      sComment = sComment + " 1st Down";

   if (ExtMapBuffer3[0] != 0)
      sComment = sComment + " 2nd UP";
      
   if (ExtMapBuffer4[0] != 0)
      sComment = sComment + " 2nd Down";
      
   if (ExtMapBuffer5[0] != 0)
      sComment = sComment + " 3rd UP";
      
   if (ExtMapBuffer6[0] != 0)
      sComment = sComment + " 3rd Down";
      
    if (ExtMapBuffer7[0] != 0)
      sComment = sComment + " 4th UP";
      
   if (ExtMapBuffer8[0] != 0)
      sComment = sComment + " 4th Down";


   if ((sComment != "") && (!IsTesting()))
   {
      if (AlertsON==true && NewBar())
      {
         PlaySound("expert.wav");
         Print(Symbol(), " ", sComment);
      }
      Comment(TimeToStr(CurTime()), " ", sComment);
   }
   if ((sComment == "") && (!IsTesting()))
   {
      Comment("");
   }

   return(0);
  }
//+------------------------------------------------------------------+

bool NewBar()
{
   static datetime dt = 0;
   //if (dt == 0) dt = Time[0];
   if (dt != Time[0])
   {
      dt = Time[0];
      return(true);
   }
   return(false);
}